# Order Management System

Bu sistem, JSON formatındaki sipariş verilerini alıp veritabanına kaydeden bir PHP uygulamasıdır.

## Kurulum

### 1. Veritabanı Kurulumu

MySQL/MariaDB veritabanınızda `database_schema.sql` dosyasını çalıştırın:

```bash
mysql -u root -p < database_schema.sql
```

Veya phpMyAdmin üzerinden SQL dosyasını import edin.

### 2. Veritabanı Ayarları

`config.php` dosyasındaki veritabanı bilgilerini düzenleyin:

```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'order_management');
define('DB_USER', 'root');
define('DB_PASS', '');
```

### 3. Dosya İzinleri

PHP'nin dosya yazma izinlerine sahip olduğundan emin olun.

## Kullanım

### Yöntem 1: cURL ile JSON Gönderme

```bash
curl -X POST https://siparis.grantoys.com.tr/save_order.php \
  -H "Content-Type: application/json" \
  -d @order.json
```

### Yöntem 2: PHP ile Gönderme

```php
<?php
$orderData = [
    "orderId" => 202034,
    "orderCode" => "642OS4MKA1IY",
    // ... diğer alanlar
];

$ch = curl_init('https://siparis.grantoys.com.tr/save_order.php');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($orderData));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

$response = curl_exec($ch);
curl_close($ch);

echo $response;
```

### Yöntem 3: JSON Dosyasından Okuma

`save_order.php` dosyası, `php://input` üzerinden gelen JSON'u otomatik olarak okur.

### Yöntem 4: Form ile Dosya Yükleme

```html
<form action="save_order.php" method="POST" enctype="multipart/form-data">
    <input type="file" name="order_file" accept=".json">
    <button type="submit">Gönder</button>
</form>
```

## API Yanıt Formatı

### Başarılı Yanıt

```json
{
    "success": true,
    "message": "Order saved successfully",
    "order_code": "642OS4MKA1IY"
}
```

### Hata Yanıtı

```json
{
    "success": false,
    "message": "Error message here"
}
```

## Veritabanı Yapısı

Sistem tek bir **orders** tablosu kullanır. Tüm sipariş bilgileri (sipariş detayları, depo/mağaza, ürün, müşteri ve teslimat adresi) bu tabloda toplanmıştır.

**orders** tablosu şu bilgileri içerir:
- Sipariş temel bilgileri (order_id, order_code, order_date, vb.)
- Depo ve mağaza bilgileri (bim_warehouse_code, bim_store_name, vb.)
- Ürün bilgileri (bim_product_code, company_product_name, vb.)
- Müşteri bilgileri (customer_tckn, customer_name1, customer_phone1, vb.)
- Teslimat adresi bilgileri (delivery_city_name, delivery_address1, vb.)

## Gereksinimler

- PHP 7.4 veya üzeri
- MySQL 5.7 veya üzeri / MariaDB 10.2 veya üzeri
- PDO MySQL extension
- JSON extension

## Güvenlik Notları

- Üretim ortamında HTTPS kullanın
- Veritabanı şifrelerini güvenli tutun
- Input validation ekleyin
- SQL injection koruması için prepared statements kullanılıyor
- Rate limiting ekleyebilirsiniz

## Test

`example_usage.php` dosyasını çalıştırarak örnek kullanımı test edebilirsiniz:

```bash
php example_usage.php
```

