<?php
/**
 * Toplu Sipariş Gönderimi
 * Seçilen veya tüm siparişleri API'ye gönderir
 */

require_once 'config.php';
require_once 'api_client.php';

header('Content-Type: application/json; charset=utf-8');

try {
    $pdo = getDBConnection();
    $apiClient = new ECommerceAPIClient();
    
    // Gönderilmemiş siparişleri getir (isteğe bağlı - api_sent kolonu varsa)
    $query = "SELECT * FROM orders ORDER BY created_at DESC";
    
    // Eğer sadece gönderilmemişleri istiyorsanız:
    // $query = "SELECT * FROM orders WHERE api_sent IS NULL OR api_sent = 0 ORDER BY created_at DESC";
    
    // Limit (toplu gönderim için)
    $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 10;
    $query .= " LIMIT " . $limit;
    
    $stmt = $pdo->query($query);
    $orders = $stmt->fetchAll();
    
    if (empty($orders)) {
        throw new Exception("Gönderilecek sipariş bulunamadı");
    }
    
    $results = [
        'total' => count($orders),
        'success' => 0,
        'failed' => 0,
        'details' => []
    ];
    
    foreach ($orders as $order) {
        try {
            $result = $apiClient->createOrder($order);
            
            if ($result['success']) {
                $results['success']++;
                $results['details'][] = [
                    'order_code' => $order['order_code'],
                    'status' => 'success',
                    'message' => $result['message'],
                    'api_order_code' => $result['order_code'] ?? null
                ];
            } else {
                $results['failed']++;
                $results['details'][] = [
                    'order_code' => $order['order_code'],
                    'status' => 'failed',
                    'message' => $result['message']
                ];
            }
            
            // Kısa bir bekleme (API rate limit için)
            usleep(500000); // 0.5 saniye
            
        } catch (Exception $e) {
            $results['failed']++;
            $results['details'][] = [
                'order_code' => $order['order_code'],
                'status' => 'error',
                'message' => $e->getMessage()
            ];
        }
    }
    
    http_response_code(200);
    echo json_encode($results, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}

