<?php
/**
 * Example usage of save_order.php
 * This file demonstrates how to send order data to the save_order.php endpoint
 */

// Example order data (from the JSON you provided)
$orderData = [
    "orderId" => 202034,
    "orderCode" => "642OS4MKA1IY",
    "orderDate" => "12.11.2023",
    "orderTime" => "14:58:19",
    "orderTotalQuantity" => 1,
    "unitPrice" => 99999.0,
    "totalPrice" => 99999.0,
    "taxRate" => 20.0,
    "paymentType" => "",
    "bimInvoiceNumber" => "",
    "bimWareHouseCode" => "9550",
    "bimWareHouseName" => "ESENKENT-2",
    "bimStoreCode" => "H997",
    "bimStoreName" => "ARMİNA / BAŞAKŞEHİR",
    "bimProductCode" => "1636425",
    "bimEanCode" => "6971636407010",
    "bimProductName" => "ÇAMAŞIR MAKİNESİ",
    "bimInvoiceDescription" => "|9550|H997|",
    "companyCode" => "1110004335",
    "companyName" => "EVE TESLİM ÜRÜN TEST FİRMASI",
    "companyProductCode" => "6971636407010",
    "companyEanCode" => "1636425",
    "companyProductName" => "ÇAMAŞIR MAKİNESİ",
    "customerTckn" => "11111111111",
    "customerName1" => "Mehmet",
    "customerSurname1" => "Beyaz",
    "customerPhone1" => "55511234567",
    "customerName2" => "",
    "customerSurname2" => "",
    "customerPhone2" => "",
    "deliveryCityName" => "İSTANBUL",
    "deliveryDistrictName" => "BEYLİKDÜZÜ",
    "deliveryNeighbourhoodName" => "CUMHURİYET",
    "deliveryAddress1" => "Milliyet Mah. Atatürk Blv. No 54",
    "deliveryAddress2" => ""
];

// Method 1: Using cURL to send JSON
function sendOrderViaCurl($orderData, $url = 'https://siparis.grantoys.com.tr/save_order.php') {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($orderData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Content-Length: ' . strlen(json_encode($orderData))
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    return [
        'http_code' => $httpCode,
        'response' => json_decode($response, true)
    ];
}




echo "\n=== Example 2: Send order from JSON file ===\n";
// First, save the example data to a file
file_put_contents('order_example.json', json_encode($orderData, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
$result = sendOrderFromFile('order_example.json');
print_r($result);

